<?php
/**
 * @package Linen
 */

if ( post_password_required() ) : ?>
	<p class="nocomments"><?php _e( 'This post is password protected. Enter the password to view comments.', 'linen' ); ?></p>
	<?php
	return;
endif; ?>
<div id="comments">
<?php if ( have_comments() ) : ?>
	<div class="comment-number clear">
		<span><?php comments_number( __( 'No Comments', 'linen' ), __( 'One Comment', 'linen' ), sprintf( __( '%s Comments', 'linen' ), get_comments_number ())); ?></span>
		<?php if ( comments_open() ) : ?>
			<a id="leavecomment" href="#respond" title="<?php esc_attr_e( 'Post a comment', 'linen' ); ?>"> <?php _e( 'Post a comment', 'linen' ); ?></a>
		<?php endif; ?>
	</div><!--end comment-number-->
	<ol class="commentlist">
		<?php wp_list_comments( 'type=comment&callback=linen_custom_comment' ); ?>
	</ol>

	<div class="navigation clear">
		<div class="alignright"><?php next_comments_link(__( 'Newer Comments &raquo;', 'linen' )); ?></div>
		<div class="alignleft"><?php previous_comments_link(__( '&laquo; Older Comments', 'linen' )); ?></div>
	</div>
	<?php if ( ! empty($comments_by_type['pings']) ) : ?>
		<h3 class="pinghead"><?php _e( 'Trackbacks &amp; Pingbacks', 'linen' ); ?></h3>
		<ol class="pinglist">
			<?php wp_list_comments( 'type=pings&callback=linen_list_pings' ); ?>
		</ol>

		<div class="navigation clear">
			<div class="alignleft"><?php next_comments_link(__( '&laquo; Older Pingbacks', 'linen' )); ?></div>
			<div class="alignright"><?php previous_comments_link(__( 'Newer Pingbacks &raquo;', 'linen' )); ?></div>
		</div>
	<?php endif; ?>
<?php elseif ( comments_open() ) : // this is displayed if there are no comments so far ?>
	<!-- If comments are open, but there are no comments. -->
	<div class="comment-number">
		<span><?php _e( 'No comments yet', 'linen' ); ?></span>
	</div>
<?php endif; ?>
<?php if ( have_comments() && ! comments_open() && ! is_page() ) : // displayed when comments are closed, regardless of # of comments ?>
	<p class="note"><?php _e( 'Comments are closed.', 'linen' ); ?></p>
<?php endif; ?>
</div><!--end comments-->

<?php comment_form();