<?php
/**
 * Template Name: Archives
 *
 * @package Linen
 */

get_header(); ?>
	<?php $archive_query = new WP_Query( 'showposts=25' ); ?>
	<?php if ( $archive_query->have_posts() ) : ?>
		<h1 class="pagetitle"><?php bloginfo( 'title' ); ?> <?php _e( 'Archives', 'linen' ); ?></h1>
		<div class="entry">
			<h2><?php _e( 'Recent Posts', 'linen' ); ?></h2>
		</div><!--end-entry-->
		<div class="entries">
			<ul>
				<?php while ( $archive_query->have_posts() ) : $archive_query->the_post(); ?>
					<li class="clear">
						<span><?php the_time( get_option( 'date_format' ) ); ?></span>
						<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php echo esc_attr( sprintf( __( 'Permanent Link to %s', 'linen' ), get_the_title() ) ); ?>"><?php the_title(); ?></a>
					</li>
				<?php endwhile; ?>
			</ul>
		</div><!--end entries-->
	<?php endif; ?>
	<?php wp_reset_postdata(); ?>
	<div class="entry">
		<h2><?php _e( 'Monthly Archives', 'linen' ); ?></h2>
		<ul>
			<?php wp_get_archives( 'type=monthly&show_post_count=1' ); ?>
		</ul>
	</div><!--end-entry-->
</div><!--end content-->
<?php get_sidebar(); ?>
<?php get_footer(); ?>